#########################################################################################################
# Analysis for the paper  - Factors Affecting User's Behavioral Intention and Use of a Mobile-Phone-
# Delivered Cognitive Behavioral Therapy for Insomnia: a Small-Scale UTAUT Analysis -
# Section: Results/Multiple-Path Test
# Figure The PLS-SEM analysis based on the multi-path analysis. 
# 2018 TUDelft
# Output file "small_q2_89samples.txt" will be created 
#
# required datafiles
# - Output/Q2/multiple path/summary_Q2.sav
#########################################################################################################

#adjust this to folder that contain data files
setwd("/Users/Siska/Documents/temp-berkas/my work/Corine's paper/BMC/stat/")

########### libraries
library(foreign)
library(MASS)
library(psych)
###########

d89=read.spss("Acceptance research/smartpls scripts, data & results/Output/Q2/multiple path/summary_Q2.sav", to.data.frame=TRUE, use.value.labels = FALSE, reencode=NA)

# data fields
# Acceptance Data:
#     HM Hedonic Motivation
#     BI Behavioral Intention
#     FC Facilitating Condition
#
# User Behavioral Data:
#     UB Use Behavior
#


f <- function(x, output) {
  q2_incl <- as.numeric(x[3])
  q2_excl <- as.numeric(x[4])
  small_q2 <- (q2_incl-q2_excl)/(1-q2_incl)
  cat(paste(x[1], x[2], x[3], x[4], round(small_q2, digit=2), sep="    "))
  cat("\n")
}

# direct output to a file 
sink("Acceptance research/r results/small_q2_89samples.txt", append=FALSE, split=FALSE)
cat("\nRESULTS OF q2 of 89 samples: \n\n")
cat("IV          DV          Q2_incl  Q2_excl  q2 \n")
apply(d89, 1, f)

cat("\n\n################ End of small q2 calculation ################### \n")

######### stop redirecting output.
sink()